#ifdef GL_ES
    precision mediump float;
#endif

varying vec4 v_color;
varying vec2 v_texCoords;
uniform sampler2D u_texture;

void main() {
    // Simple curved screen effect
    vec2 uv = v_texCoords - 0.5;
    float dist = uv.x * uv.x + uv.y * uv.y;
    uv = uv * (1.0 + dist * 0.15);
    vec2 curvedUV = uv + 0.5;
    
    // Get color with curve
    vec4 color = texture2D(u_texture, clamp(curvedUV, 0.0, 1.0)) * v_color;
    
    // Scan lines (simplified)
    float scanLine = sin(curvedUV.y * 600.0) * 0.05;
    color.rgb += vec3(scanLine);
    
    // Simple vignette
    float vignette = 1.0 - dist * 0.5;
    vignette = clamp(vignette, 0.7, 1.0);
    color.rgb *= vignette;
    
    // Darken edges for curvature
    float edgeDark = 1.0 - smoothstep(0.0, 0.5, dist);
    color.rgb *= mix(1.0, 0.9, edgeDark);
    
    // Warm tint (not purple)
    color.rgb *= vec3(1.02, 1.0, 0.98);
    
    gl_FragColor = color;
}